.H 1 "Dbmonpi Window"
This window attaches rtpi to programs running under the control of the debug
monitor.
The window provide the same user interface for several different
processor types.
.P
The window provides several options for attaching to programs.
You can down-load and start a program from the window or
attach to executing programs.
If a program is running when the window is opened
a line displays the program's name.
When a program is opened a new window hierarchy can be created to examine it,
or an existing window hierarchy that has already been set up to 
debug a different instance of the same program on the same processor
can be taken over.
.P
The Signals window is not available for application
programs running under the control of the debug monitor,
as exceptions are either handled by the application directly or
suspend the application and jump into the monitor.
.P
Two programs, rt and rthang, are provided with the debug monitor software
to down-load programs to processors running the debug monitor
from outside of rtpi.
Rt down-loads a program and starts executing it.
Its command line syntax is:
.DS I N
rt debug_agent:processor_name program [arg1 ...]
.DE
.P
For example, to down-load the program a.out on the processor named dsp1 that is
accessible through the debug agent running on the system with
Internet name vme3, type:
.DS I N
rt vme3:dsp1 a.out
.DE
.P
Rthang down-loads a program like rt, but suspends it before
the first instruction is executed so it may be debugged.
Rthang's command line syntax is:
.DS I N
rthang debug_server:processor_name program [arg1 ...]
.DE
.P
WARNING: When a new program is down-loaded with either rt or rthang,
the debug monitor kills the program that was previously executing.
If the killed program used interrupts,
some interrupts lines may be left asserted when the program is killed.
A hardware reset of the processor may be necessary before a program
that does not service those interrupts is run.
.H 2 "Dbmonpi Layout"
The title bar identifies the type of window, debug agent and processor name.
The window type depends on the processor type, and is either Dsp32cpi,
68000pi, 68010pi, 68020pi, or 32100pi.
The debug agent field lists the entry in the Rtpi window that
was used to connect to the agent, while the processor name
is a copy of the processor's entry in the Processors window.
.P
Within the window lines that start with `!', such as "! a.out",
are used to down-load and start new programs.
The rest of the line is the name of the file containing the executable
code and the symbol table.
Other lines are in the format:
.DS I N
processor_name:-1 program
.DE
.P
and attach the debugger to running programs.
The processor_name:-1 field is the distributed system process id,
and appears everywhere windows associated with the program expect
to place a process id, such as title bars.
By convention, programs running under the debug monitor are
assigned a process id number of -1.
The name of the executable file, program,
is stored in the debug monitor when the program is down-loaded.
.P
When a Dbmonpi window is initially opened it contains the line "!a.out".
This allows program a.out to be down-loaded and serves as reminder
of the down-loading keyboard syntax.
If a program is executing when the window is opened,
an additional line is inserted that allows the debugger to attach to it.
.H 2 "Dbmonpi Menu Bar"
.VL 7 1
.LI "ps"
Update the line displaying the name of the currently executing program.
The window is updated automatically if new programs are down-loaded with
the line menu entries, so this entry should only be needed if
a new program is down-loaded from outside of the debugger.
.H 2 "Dbmonpi Keyboard"
Syntax
.DS I N
!program [arg1 ...]
program
.DE
.P
The Dbmonpi window's keyboard language allows new programs to be down-loaded
or the debugger to be attached to existing programs.
Entering a line inserts a new line in the window but does not
perform any operations on the remote system.
To create the window hierarchy for a program the line menus must be used.
.P
Lines that start with `!' down-load and start new programs. 
The optional arguments are passed to the program when it is started
if the debug monitor supports passing arguments to main().
The program must be in the current working directory or be a full path name.
.P
Lines that do not start with `!' are used to type in the name
of the symbol table file for a running program.
This format is not needed often as the window displays the name
of the current program when the window is opened.
However, if the program name maintained by the debug monitor is 
incorrect because the file was renamed or moved, this format may
be used to override it.
A process id number is not required as the debug monitor only
supports a single program.
When a line in this format is entered it is displayed in the format:
.DS I N
processor_name:-1 program
.DE
.H 2 "Dbmonpi Line Menus"
If the line starts with `!' it starts a new program from rtpi
and the line menu has the following entries:
.VL 19 1
.LI "hang & open proc"
Reset the processor, down-load the program,
and suspend it before the first instruction is executed.
This is equivalent to using rthang to start the program from outside of rtpi.
After the program is down-loaded an entry in the
form "processor_name:-1 program"
is inserted into the window, and a new Process window is opened for it.
Down-loading a new program kills the program that were previously executing
and closes any rtpi windows that were associated with it.
.LI "hang & take over"
This entry is similar to "hang & open proc",
except rather than creating a new set of windows,
a pop-up window will ask you to choose an existing window hierarchy
to take over.
To work successfully, the process chosen must be another instance of the
same program running on the same processor.
If successful, the debugger kills the currently executing program,
down-loads a new copy of the program,
and attaches the existing window hierarchy to the new instance of the program.
In addition to the windows, the new process inherits the breakpoints
that were set in the previous process.
This menu entry is particularly useful if
you discover you have gone too far while debugging a program
and would like to rerun the
program without going through the effort of opening the windows,
resetting the data formatting options, and placing the breakpoints.
.LE
.P
Lines in the format "processor_name:-1 program" generate menus that contain:
.VL 15 1
.LI "open process"
Attach the debugger to the program and open a new Process window for it.
Program, the executable file containing the symbol table,
must be in the current directory or be a
full path name to open the process successfully.
.LI "take over"
Similar to "open process", except instead of creating a new set of
windows a pop-up window asks you to choose an existing set
of windows to take over.
This entry is used when the new instance of the program
is down-loaded from outside of rtpi.
.LE
